/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.ChatCommands;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.messages.ServerboundChatWindowPacket;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public final class GuildChatCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        CommandHelper.register(dispatcher, "guild", "chat", GuildChatCommands::openChatScreen);
        CommandHelper.register(dispatcher, "gc", GuildChatCommands::openChatScreen);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then(GuildChatCommands.sendMessage("chat")));
        dispatcher.register(GuildChatCommands.sendMessage("gc"));
    }

    public static void openChatScreen(class_3222 player) throws MemberException {
        Guild guild = GuildApi.API.get(player);
        if (guild == null) {
            throw MemberException.YOU_ARE_NOT_IN_GUILD;
        }
        ChatCommands.openChatScreen(player, guild, ChatMessageType.GUILD, ConstantComponents.GUILD_CHAT_TITLE);
    }

    private static LiteralArgumentBuilder<class_2168> sendMessage(String name) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Guild guild = GuildApi.API.get(player);
                if (guild == null) {
                    throw MemberException.YOU_ARE_NOT_IN_GUILD;
                }
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                MessageChannel channel = ChatHandler.getChannel(guild, ChatMessageType.GUILD);
                ServerboundChatWindowPacket.sendMessage(player, guild, message, channel);
            });
            return 1;
        }));
    }
}

