/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.ChatCommands;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.messages.ServerboundChatWindowPacket;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public final class PartyChatCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        CommandHelper.register(dispatcher, "party", "chat", PartyChatCommands::openChatScreen);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"party").then(PartyChatCommands.sendMessage()));
    }

    public static void openChatScreen(class_3222 player) throws MemberException {
        Party party = PartyApi.API.get((class_1657)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        ChatCommands.openChatScreen(player, party, ChatMessageType.PARTY, ConstantComponents.PARTY_CHAT_TITLE);
    }

    private static ArgumentBuilder<class_2168, LiteralArgumentBuilder<class_2168>> sendMessage() {
        return class_2170.method_9247((String)"chat").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CommandHelper.runAction(() -> {
                Party party = PartyApi.API.get((class_1657)player);
                if (party == null) {
                    throw MemberException.YOU_ARE_NOT_IN_PARTY;
                }
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                MessageChannel channel = ChatHandler.getChannel(party, ChatMessageType.PARTY);
                ServerboundChatWindowPacket.sendMessage(player, party, message, channel);
            });
            return 1;
        }));
    }
}

