/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.GroupType;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.base.members.Members;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ServerboundSetRolePacket(String role, GroupType type, UUID member) implements Packet<ServerboundSetRolePacket>
{
    public static final class_2960 ID = new class_2960("argonauts", "set_role");
    public static final PacketHandler<ServerboundSetRolePacket> HANDLER = new Handler();

    public class_2960 getID() {
        return ID;
    }

    public PacketHandler<ServerboundSetRolePacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundSetRolePacket> {
        private Handler() {
        }

        public void encode(ServerboundSetRolePacket message, class_2540 buffer) {
            buffer.method_10814(message.role);
            buffer.method_10817((Enum)message.type);
            buffer.method_10797(message.member);
        }

        public ServerboundSetRolePacket decode(class_2540 buffer) {
            return new ServerboundSetRolePacket(buffer.method_19772(), (GroupType)buffer.method_10818(GroupType.class), buffer.method_10790());
        }

        public PacketContext handle(ServerboundSetRolePacket message) {
            return (player, level) -> CommandHelper.runNetworkAction(player, () -> {
                Group group = null;
                if (message.type == GroupType.GUILD) {
                    group = GuildApi.API.get((class_3222)player);
                } else if (message.type == GroupType.PARTY) {
                    group = PartyApi.API.get(player);
                }
                if (group == null) {
                    return;
                }
                Object member = group.getMember(player);
                if (!((Member)member).hasPermission("roles.members")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                Object selected = ((Members)group.members()).get(message.member);
                if (selected != null && !((Member)selected).getState().isLeader()) {
                    ((Member)selected).setRole(message.role);
                }
            });
        }
    }
}

