/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.utils;

import com.google.common.primitives.UnsignedInteger;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.utils.fabric.ModUtilsImpl;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public final class ModUtils {
    public static final UnsignedInteger UNSIGNED_TWO = UnsignedInteger.valueOf((long)2L);
    public static final Pattern SPECIAL_COLOR_PATTERN = Pattern.compile("&&([0-9a-fklmnor])");

    public static boolean areProfilesSame(GameProfile first, GameProfile second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getId() != null && second.getId() != null) {
            return first.getId().equals(second.getId());
        }
        return first.getName() != null && second.getName() != null && first.getName().equals(second.getName());
    }

    public static class_4208 readGlobalPos(class_2487 tag) {
        class_2960 key = class_2960.method_12829((String)tag.method_10558("dimension"));
        if (key == null) {
            return null;
        }
        class_2338 pos = class_2338.method_10092((long)tag.method_10537("pos"));
        class_5321 level = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key);
        return class_4208.method_19443((class_5321)level, (class_2338)pos);
    }

    public static class_2487 writeGlobalPos(class_4208 pos) {
        class_2487 tag = new class_2487();
        tag.method_10582("dimension", pos.method_19442().method_29177().toString());
        tag.method_10544("pos", pos.method_19446().method_10063());
        return tag;
    }

    public static GameProfile readBasicProfile(class_2487 tag) {
        return new GameProfile(UUID.fromString(tag.method_10558("id")), tag.method_10558("name"));
    }

    public static class_2487 writeBasicProfile(GameProfile profile) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", profile.getId().toString());
        tag.method_10582("name", profile.getName());
        return tag;
    }

    public static String formatTextColors(String text) {
        return SPECIAL_COLOR_PATTERN.matcher(text).replaceAll(result -> "\u00a7" + result.group(1));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Pair<UUID, class_2561>> getFakePlayers() {
        return ModUtilsImpl.getFakePlayers();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2561 getParsedComponent(class_2561 component, class_3222 player) {
        void var1_1;
        return ModUtilsImpl.getParsedComponent(component, (class_3222)var1_1);
    }

    public static <T extends Packet<T>> void sendToAllClientPlayers(T packet, MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> {
            if (NetworkHandler.CHANNEL.canSendPlayerPackets((class_1657)player)) {
                NetworkHandler.CHANNEL.sendToPlayer(packet, (class_1657)player);
            }
        });
    }

    public static UUID parseUuidOrNull(String text) {
        try {
            return UUID.fromString(text);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

